/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.SliderPlusMoins;
import java.awt.Graphics;

public class SliderCube
extends SliderPlusMoins {
    public SliderCube(Aladin aladin) {
        super(aladin, aladin.getChaine().getString("SLIDERCUBE"), 0, 10, 1);
        this.setTooltip(aladin.getChaine().getString("SLIDERCUBETIP"));
    }

    @Override
    void submit(int inc) {
        Plan p = this.getPlanCube();
        if (p == null) {
            return;
        }
        double frame = this.getValue() + (double)inc;
        p.changeImgID();
        int[] vn = this.aladin.view.getNumView(p);
        if (vn != null) {
            for (int i = 0; i < vn.length; ++i) {
                this.aladin.view.setCubeFrame(this.aladin.view.viewSimple[vn[i]], frame, true);
            }
        } else {
            p.setCubeFrame(frame);
        }
        this.aladin.view.repaintAll();
    }

    Plan getPlanCube() {
        Plan[] p;
        for (Plan p1 : p = this.aladin.calque.getPlans()) {
            if (!p1.selected || !p1.isCube()) continue;
            return p1;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Plan p = this.getPlanCube();
        if (p != null) {
            this.setEnabled(true);
            this.slider.setMinMax(0, p.getDepth() - 1);
            this.slider.setValue(p.getZ());
        } else {
            this.slider.setValue(this.slider.min);
            this.setEnabled(false);
        }
        super.paintComponent(g);
    }
}

